<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

if (!$vbulletin->userinfo['userid'] OR !$show['downloads_canimport'])
{
	// No permission to manage imports
	print_no_permission();
}

// #############################################################################
if ($_REQUEST['action'] == 'import' OR empty($_REQUEST['action']))
{
	// Add to the navbits
	$navbits[''] = $pagetitle = $vbphrase['dbtech_downloads_import_files'];
	
	// Create the archive template
	$templater = vB_Template::create('dbtech_downloads_import');
		$templater->register('pagetitle', 	$pagetitle);
		$templater->register('errstr', 		$errstr);
		$templater->register('filebits', 	$filebits);
		$templater->register('folderpath', 	$vbulletin->options['dbtech_downloads_path_to_imports']);
	$HTML = $templater->render();
}

// #############################################################################
if ($_POST['action'] == 'doimport')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'download' 		=> TYPE_ARRAY,
		'folderpath' 	=> TYPE_NOHTML,
	));

	$errstr = '';
	$filebits = array('new' => '', 'existing' => '');
	do
	{
		if (!$vbulletin->GPC['folderpath'])
		{
			// Not set, quit silently
			break;
		}

		if (substr($vbulletin->GPC['folderpath'], -1) == '/')
		{
			// Get rid of trailing slash
			$vbulletin->GPC['folderpath'] = substr($vbulletin->GPC['folderpath'], 0, -1);
		}

		$folderpath = $vbulletin->GPC['folderpath'];
		if (substr($vbulletin->GPC['folderpath'], 0, 2) == './')
		{
			// Prepare this
			$folderpath = str_replace('./', DIR . '/', $vbulletin->GPC['folderpath']);
		}

		if (!@is_dir($vbulletin->GPC['folderpath']) OR !@is_readable($vbulletin->GPC['folderpath']))
		{
			$errstr = $vbphrase['dbtech_downloads_folder_not_readable'];
			break;
		}

		$extensions = array();
		foreach (VBDOWNLOADS::$cache['extension'] as $extension)
		{
			// Reorder this by extension 
			// (I bet "extension" doesn't even sound like a real word to you anymore after reading this)
			$extensions[$extension['extension']] = $extension;
		}

		if (!count($vbulletin->GPC['download']))
		{
			$fileList = VBDOWNLOADS::$db->fetchAllKeyed('
				SELECT *
				FROM $dbtech_downloads_file
				WHERE filepath = ?
			', 'filename', array(
				$vbulletin->GPC['folderpath'],
			));

			// Grab ordered list
			$categoryList = construct_ordered_categories();

			// Construct the list of select options
			construct_category_select_options($categories, $categoryList);

			$categoryOptions = '';
			foreach ($categories as $categoryid => $title)
			{
				if (in_array($categoryid, $_excludeCategories))
				{
					// Can't view category
					continue;
				}

				if (!$category = VBDOWNLOADS::$cache['category'][$categoryid])
				{
					// Invalid category
					continue;
				}

				if (($category['owner'] AND $category['owner'] != $vbulletin->GPC['userid']) AND !VBDOWNLOADS::$permissions['ismanager'])
				{
					// Wrong owner
					continue;
				}

				$templater = vB_Template::create('option');
					$templater->register('optionvalue', 	$categoryid);
					$templater->register('optiontitle', 	htmlspecialchars_uni($title));
				$categoryOptions .= $templater->render();
			}

			// Shop icons
			$d = dir($vbulletin->GPC['folderpath']);
			$i = 0;
			while (false !== ($file = $d->read()))
			{
				if ($file == '.')
				{
					// Ignore dot files
					continue;
				}
				
				if ($file == '.')
				{
					// Ignore dot files
					continue;
				}
				
				if ($file == 'index.html')
				{
					// Ignore directory indexer
					continue;
				}

				if (!@is_readable($folderpath . '/' . $file))
				{
					// File is not readable
					continue;
				}

				if (!isset($extensions[pathinfo($file, PATHINFO_EXTENSION)]))
				{
					// Invalid extension
					continue;
				}
				
				// Create the archive template
				$templater = vB_Template::create('dbtech_downloads_import_filebit');
					$templater->register('filename', 		$file);
					$templater->register('categoryOptions', $categoryOptions);
					$templater->register('i', 				$i++);
				$filebits[isset($fileList[$file]) ? 'existing' : 'new'] .= $templater->render();
			}
			$d->close();
		}
		else
		{
			foreach ($vbulletin->GPC['download'] as $downloadInfo)
			{
				if ($downloadInfo['skipfile'])
				{
					// Skip this file
					continue;
				}

				if (!$category = VBDOWNLOADS::$cache['category'][$downloadInfo['categoryid']])
				{
					// Invalid category
					continue;
				}

				if (in_array($category['categoryid'], $_excludeCategories))
				{
					// Can't view category
					continue;
				}

				if (($category['owner'] AND $category['owner'] != $vbulletin->GPC['userid']) AND !VBDOWNLOADS::$permissions['ismanager'])
				{
					// Wrong owner
					continue;
				}

				if (!@is_readable($folderpath . '/' . $downloadInfo['filename']))
				{
					// File is not readable
					continue;
				}

				$downloadInfo['extension'] = pathinfo($downloadInfo['filename'], PATHINFO_EXTENSION);
				if (!isset($extensions[$downloadInfo['extension']]))
				{
					// Invalid extension
					continue;
				}

				// Set this
				$downloadInfo['numfiles'] = 1;

				// init data manager
				$dm =& VBDOWNLOADS::initDataManager('Download', $vbulletin, ERRTYPE_STANDARD);
					$dm->set('title', 		$downloadInfo['title']);
					$dm->set('categoryid', 	$downloadInfo['categoryid']);
					$dm->set('numfiles', 	$downloadInfo['numfiles']);
					$dm->set('userid', 		$vbulletin->userinfo['userid']);
				$downloadid = $dm->save();

				if (!$downloadid)
				{
					// Skip this now
					continue;
				}

				// init data manager
				$dm =& VBDOWNLOADS::initDataManager('File', $vbulletin, ERRTYPE_STANDARD);
					$dm->set('userid', 		$vbulletin->userinfo['userid']);
					$dm->set('filename', 	$downloadInfo['filename']);
					$dm->set('filesize', 	intval(@filesize($folderpath . '/' . $downloadInfo['filename'])));
					$dm->set('image', 		$extensions[$downloadInfo['extension']]['isimage']);
					$dm->set('downloadid', 	$downloadid);
					$dm->set('hashkey', 	md5($folderpath . '/' . $downloadInfo['filename']));
					$dm->set('filepath', 	$vbulletin->GPC['folderpath']);
				$dm->save();
			}
		}
	}
	while (false);

	if ($errstr OR $filebits['new'] OR $filebits['existing'])
	{
		// Add to the navbits
		$navbits[''] = $pagetitle = $vbphrase['dbtech_downloads_import_files'];
		
		// Create the archive template
		$templater = vB_Template::create('dbtech_downloads_import');
			$templater->register('pagetitle', 	$pagetitle);
			$templater->register('errstr', 		$errstr);
			$templater->register('filebits', 	$filebits);
			$templater->register('folderpath', 	$vbulletin->GPC['folderpath']);
		$HTML = $templater->render();
	}
	else
	{
		$vbulletin->url = $vbulletin->options['dbtech_downloads_link'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'do=import';
		eval(print_standard_redirect('redirect_dbtech_downloads_files_imported'));
	}
}